--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--
--Action.AddCampFlag(flag-n, number)														--
--Action.AddImage("filname.jpg")															--
--Action.CampaignEnd("win"/"draw"/"loss")													--
--Action.TargetActive("TargetName", boolean)												--
--Action.AirUnitActive("UnitName", boolean)													--
--Action.AirUnitBase("UnitName", "BaseName")												--
--Action.AirUnitPlayer("UnitName", boolean)													--
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--
--Action.AirUnitRepair()																	--
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--
--Action.GroupHidden("GroupName", boolean)													--
--Action.GroupProbability("GroupName", number 0-1)											--
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("December the 7th of 1971. Pakistan is ready to launch air raids this morning against our main airbases. We are ready to stop them and to launch a massive counter attack on sea, land and in the air.")',
			[2] = 'Action.Text("Our Air forces are ready with No 4, 28 and 30 Squadron flying on MiG-21 FL and No 221 Squadron flying on Su-7 BMK.")',
			[3] = 'Action.Text("The Pakistan air forces are mainly flying on F-86F Sabre with 2 squadrons and 1 squadron of deadly Shenyang F-6. Our goal will be to gain air superiority by neutralizing main bases and destroying as many planes as possible. Then we will attack Pakistan ground forces to help our ground forces offensives on the East and West front.")',
			[4] = 'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
			[5] = 'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
		},
	},
	
----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 100',
		action = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 80',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 60',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 50',
		action = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
	},

	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = false,
		condition = 'GroundTarget["red"].percent < 45',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The Indian Air Force have successfully destroyed all the targets that they were assigned by Central Command. With the heavy losses inflicted to the Pakistan ground forces, our offensive will be easier. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 2"] = {
		active = true,
		once = false,
		condition = 'Return.AirUnitReady("No 11 Squadron") + Return.AirUnitReady("No 14 Squadron") + Return.AirUnitReady("No 15 Squadron") < 4',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The Pakistan Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Pakistan are no longer able to produce any sorties or offer any resistance. The Indian forces now owns complete air superiority. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Victory 3"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Gudauta Airbase") < 10 and Return.TargetAlive("Sukhumi Airbase") < 4 and Return.TargetAlive("Sukhumi Airbase Strategics") < 5',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The Pakistan Air Force is in ruins. All their bases are destroyed, the Pakistan are no longer able to produce any sorties or offer any resistance. The Indian forces now owns complete air superiority. Well done.")',
			[3] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[4] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = false,
		condition = 'Return.AirUnitAlive("No 30 Squadron") + Return.AirUnitReady("R/No 30 Squadron") < 4',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("Ongoing combat operations have exhausted No 30 Squadron. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of Indian Air Force to attain air superiority, Central Command has decided to call of the air campaign against the Pakistan. They will be able to attack our country and our diplomatic power in the world is really weaked by this defeat.")',
			[3] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[4] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Loss 2"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Kutaisi Airbase") < 10',
		action = {
			[1] = 'db_airbases["Kutaisi"].inactive = true',
			[2] = 'Action.CampaignEnd("loss")',
			[3] = 'Action.Text("After Kutaisi airbase has been hit and is nearly disable, No 30 Squadron is no longer able to fly. Our troops will have to continue the fight without our Squadron. This is a bitter failure for the Air Force")',
			[4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[5] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[6] = 'NoMoreNewspaper = true',
			
		}
	},
	
	
	-- ["Campaign End Loss 2"] = {
		-- active = true,
		-- once = false,
		-- condition = 'Return.TargetAlive("CVN-70 Carl Vinson") == 0',
		-- action = {
			-- [1] = 'Action.CampaignEnd("loss")',
			-- [2] = 'Action.Text("After the CVN-70 Carl Vinson has been hit by air strikes and sunk, VFA-131 is no longer able to fly. Most of its planes are deep into the Caucasian waters and it will need a long time to restore this unit s capabilities. Other US Navy units will have to continue the fight without the VFA-131 support. This is a bitter failure for the Navy")',
			-- [3] = 'Action.AddImage("Newspaper_Defeat.jpg", "blue")',
			-- [4] = 'NoMoreNewspaper = true',
		-- },
	-- },	
	["Campaign End Draw"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() >= 50',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Pakistan Air Force and infrastructure, Indian Central Command has called off all squadrons from offensive operations. We hope negociations with India will convince them to stop the war")',
			[3] = 'NoMoreNewspaper = true',
		},
	},
	-- ["CVN-70 Carl Vinson Sunk"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.UnitDead("CVN-70 Carl Vinson")',
		-- action = {
			-- [1] = 'Action.CampaignEnd("loss")',
			-- [2] = 'Action.Text("CVN-70 Carl Vinson has been lost, the exact cause of her sinking is still somewhat unclear at the moment. Despite her evacuation being orderly and escorts of the Battle Group picking up many survivors, losses are expected to be very high. Search and rescue operations are still ongoing. Airborne aircraft of VFA-131 have scattered to CVN-68 Nimitz. All combat operations against Russian forces have been put on hold until further notice.")',
			-- [3] = 'Action.Text("The loss of an aircraft carrier is a severe blow to the United States Navy which will shake up the service for years to come.")',
		-- }	
	-- },
	-- ["CVN-70 Carl Vinson Damaged Light"] = {
		-- active = true,
		-- once = true,
		-- condition = 'camp.ShipHealth and camp.ShipHealth["CVN-70 Carl Vinson"] and camp.ShipHealth["CVN-70 Carl Vinson"] < 100 and camp.ShipHealth["CVN-70 Carl Vinson"] >= 66',
		-- action = {
			-- [1] = 'Action.Text("CVN-70 Carl Vinson has sustained light damage under circumstances still somewhat unclear at the moment. Flight operations continue as scheduled.")',
		-- }	
	-- },
	-- ["CVN-70 Carl Vinson Damaged Moderate"] = {
		-- active = true,
		-- once = true,
		-- condition = 'camp.ShipHealth and camp.ShipHealth["CVN-70 Carl Vinson"] and camp.ShipHealth["CVN-70 Carl Vinson"] < 66 and camp.ShipHealth["CVN-70 Carl Vinson"] >= 33',
		-- action = {
			-- [1] = 'Action.CampaignEnd("loss")',
			-- [2] = 'Action.Text("CVN-70 Carl Vinson has sustained substantial damage under circumstances still somewhat unclear at the moment. Unable to continue flight operations, the carrier is retreating under own power for repairs. All combat operations against Russian forces have been put on hold until further notice.")',
		-- }	
	-- },
	-- ["CVN-70 Carl Vinson Damaged Heavy"] = {
		-- active = true,
		-- once = true,
		-- condition = 'camp.ShipHealth and camp.ShipHealth["CVN-70 Carl Vinson"] and camp.ShipHealth["CVN-70 Carl Vinson"] < 33 and camp.ShipHealth["CVN-70 Carl Vinson"] > 0',
		-- action = {
			-- [1] = 'Action.CampaignEnd("loss")',
			-- [2] = 'Action.Text("CVN-70 Carl Vinson has sustained heavy damage under circumstances still somewhat unclear at the moment. After a valiant damage control effort by its crew and support from other ships of Task Group 68.1, the complete loss of the carrier could be averted. Being taken under tow by its escorts, CVN-70 Carl Vinson is on the way to friendly harbor for emergency repairs before returning to the United States. All combat operations against Russian forces have been put on hold until further notice.")',
		-- }	
	-- },
	
	
	----- Missile boat movements -----
	["Missile Boat first zone ATest Sea"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() >= 1',
		action = 'Action.ShipMission("Missile Boat 1", {{"Indy 1-1", "Indy 1-2", "Indy 1-3", "Indy 1-4"}}, 12, 8, nil)',
	},
	["Missile Boat second zone ATest Sea"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() >= 1',
		action = 'Action.ShipMission("Missile Boat 2", {{"Indy 2-1", "Indy 2-2", "Indy 2-3", "Indy 2-4"}}, 12, 8, nil)',
	},

	----- CONVOY MOVEMENT -----
	["Patrol Boat 1 Patrol ATest Sea"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() >= 1',
		action = 'Action.ShipMission("Patrol Boat 1", {{"Ships 1-1", "Ships 1-2", "Ships 1-3", "Ships 1-4"}}, 8, 5, nil)',
	},
	["Patrol boat 2 Patrol ATest Sea"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() >= 1',
		action = 'Action.ShipMission("Patrol Boat 2", {{"Ships 1-5", "Ships 1-4", "Ships 1-3", "Ships 1-6"}}, 8, 5, nil)',
	},


	----- UNIT DESACTIVATION -----
	-- ["Unit Desactivate B-52H and B-1B"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.Mission() >= 10',
		-- action = {
			-- [1] = 'Action.AirUnitActive("96 BW", false)',
			-- [2] = 'Action.AirUnitActive("69 BS", false)',
			-- [3] = 'Action.Text("After intensive flights against Russians SAM sites, B-52H from 96 BS and B-1B from 69 BS have reduced significantly SAM sites effectiveness. They have to stop their missions but it should be easier for TF-74 to attack strategics targets in Georgia")',
			-- [4] = 'Action.AddImage("Newspaper_Phantom.jpg")',
		-- },
	-- },	

	----- AIRBASE STRIKES -----
	["Gudauta Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Gudauta Airbase") < 10',
		action = {
			[1] = 'db_airbases["Gudauta"].inactive = true',
		}
	},
	["Gudauta Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Gudauta Airbase") < 10',
		action = {
			[1] = 'Action.Text("After the facilities at Gudauta Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	-- ["Batumi Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Batumi Airbase") < 6',
		-- action = {
			-- [1] = 'db_airbases["Batumi"].inactive = true',
		-- }
	-- },
	-- ["Batumi Airbase Disabled Text"] = {
		-- active = true,
		-- once = false,
		-- condition = 'Return.TargetAlive("Batumi Airbase") < 6',
		-- action = {
			-- [1] = 'Action.Text("After the facilities at Batumi Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		-- }
	-- },
	["Kobuleti Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Kobuleti Airbase") < 11',
		action = {
			[1] = 'db_airbases["Kobuleti"].inactive = true',
		}
	},
	["Kobuleti Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Kobuleti Airbase") < 11',
		action = {
			[1] = 'Action.Text("After the facilities at Kobuleti Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Senaki Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Senaki Airbase") < 12',
		action = {
			[1] = 'db_airbases["Senaki-Kolkhi"].inactive = true',
		}
	},
	["Senaki Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Senaki Airbase") < 12',
		action = {
			[1] = 'Action.Text("After the facilities at Senaki-Kolkhi Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},	
	["Kutaisi Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Kutaisi Airbase") < 11',
		action = {
			[1] = 'db_airbases["Kutaisi"].inactive = true',
		}
	},
	["Kutaisi Airbase Disabled Text"] = {
		active = true,
		once = false,
		condition = 'Return.TargetAlive("Kutaisi Airbase") < 11',
		action = {
			[1] = 'Action.Text("The infrastructure at Kutaisi Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. This will ease our efforts to hit other targets in the Kutaisi Country area.")',
		}
	},
	-- ["Tbilissi Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Tbilisi Airbase") < 7',
		-- action = {
			-- [1] = 'db_airbases["Tbilissi-Lochini"].inactive = true',
		-- }
	-- },
	-- ["Tbilissi Airbase Disabled Text"] = {
		-- active = true,
		-- once = false,
		-- condition = 'Return.TargetAlive("Tbilisi Airbase") < 7',
		-- action = {
			-- [1] = 'Action.Text("The infrastructure at Tbilissi-Lochini Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. This will ease our efforts to hit other targets in the Kutaisi Country area.")',
		-- }
	-- },	
	["Sukhumi Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Sukhumi Airbase") < 4 and Return.TargetAlive("Sukhumi Airbase Strategics") < 5',
		action = {
			[1] = 'db_airbases["Sukhumi"].inactive = true',
		}
	},
	["Sukhumi Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Sukhumi Airbase") < 4 and Return.TargetAlive("Sukhumi Airbase Strategics") < 5',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Sukhumi Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	["Maykop-Khanskaya Airbase Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Maykop-Khanskaya Airbase") < 6',
		action = {
			[1] = 'db_airbases["Maykop-Khanskaya"].inactive = true',
		}
	},
	["Maykop-Khanskaya Airbase Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Maykop-Khanskaya Airbase") < 6',
		action = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Maykop-Khanskaya Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		}
	},
	-- ["CVN-74 John C. Stennis sunk"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("CVN-74 John C. Stennis") == 0',
		-- action = {
			-- [1] = 'db_airbases["CVN-74 John C. Stennis"].inactive = true',
			-- [2] = 'Action.Text("After the CVN-74 John C. Stennis has been hit by air strikes and sunk, VF-101 is no longer able to fly. Most of its planes are deep into the sea and it will need a long time to restore this unit s capabilities")',			
		-- }
	-- },
	-- ["CVN-70 Carl Vinson"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("CVN-70 Carl Vinson") == 0',
		-- action = {
			-- [1] = 'db_airbases["CVN-70 Carl Vinson"].inactive = true',
			-- [2] = 'Action.Text("After the CVN-70 Carl Vinson has been hit by air strikes and sunk, VF-101 is no longer able to fly. Most of its planes are deep into the sea and it will need a long time to restore this unit s capabilities")',			
		-- }
	-- },
	-- ["CVN-71 Theodore Roosevelt"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("CVN-71 Theodore Roosevelt") == 0',
		-- action = {
			-- [1] = 'db_airbases["CVN-71 Theodore Roosevelt"].inactive = true',
			-- [2] = 'Action.Text("After the CVN-71 Theodore Roosevelt has been hit by air strikes and sunk, 7 ACCS and 174 ARW are no longer able to fly. Most of its planes are deep into the sea and it will need a long time to restore this unit s capabilities.")',			
		-- }
	-- },
	-- ["CVN-72 Abraham Lincoln"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("CVN-72 Abraham Lincoln") == 0',
		-- action = {
			-- [1] = 'db_airbases["CVN-72 Abraham Lincoln"].inactive = true',
			-- [2] = 'Action.Text("After the CVN-72 Abraham Lincoln has been hit by air strikes and sunk, VFA-192 is no longer able to fly. Most of its planes are deep into the sea and it will need a long time to restore this unit s capabilities")',			
		-- }
	-- },
	
	----- RED INTERCEPTIONS -----
	["CAP After SouthEWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR South IND - Darknight 121") == 0',
		action = {
			[1] = 'Action.Text("With the recent destruction of South Early Warning Radar site in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},
	["CAP After SouthEWR Destroyed"] = {
		active = true,
		condition = 'Return.TargetAlive("EWR South IND - Darknight 121") == 0',
		action = {
			[1] = 'Action.TargetActive("Senaki-Kolkhi Interception 1", false)',
			[2] = 'Action.TargetActive("Kutaisi Interception 1", false)',
		},
	},		
	["CAP After North EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR North IND - Warrior 122") == 0',
		action = {
			[1] = 'Action.Text("With the recent destruction of North Early Warning Radar site in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
		},
	},
		["CAP After North EWR Destroyed"] = {
		active = true,
		condition = 'Return.TargetAlive("EWR North IND - Warrior 122") == 0',
		action = {
			[1] = 'Action.TargetActive("Maykop-Khanskaya Interception 1", false)',
			[2] = 'Action.TargetActive("Maykop-Khanskaya Interception 2", false)',
		},
	},

	----- BLUE INTERCEPTIONS -----
	["CAP After PAK EWR Destroyed"] = {
        active = true,
        once = true,
        condition = 'Return.TargetAlive("EWR 1 PAK - Axeman 130") == 0',
        action = {
            [1] = 'Action.Text("With the recent destruction of Early Warning Radar site in the operations area, our ability to launch interceptors against enemy strike packages is severely degraded. We will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these will be of limited effectiveness.")',
        },
    },
	["CAP After PAK EWR Destroyed"] = {
        active = true,
        condition = 'Return.TargetAlive("EWR 1 PAK - Axeman 130") == 0',
        action = {
            [1] = 'Action.TargetActive("Sukhumi Interception 1", false)',
            [2] = 'Action.TargetActive("Gudauta Interception 1", false)',
            [3] = 'Action.TargetActive("CAP Blue West", true)',
            [4] = 'Action.TargetActive("CAP Blue East 1", true)',
            [5] = 'Action.TargetActive("CAP Blue East 2", true)',
        },
    },
	
	----- REPAIR AND REINFORCEMENTS -----
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	-- Miguel21 modification M19 : Repair SAM
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Reinforce No 11 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/No 11 Squadron", "No 11 Squadron", 12)',
	},
	["Reinforce No 14 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/No 14 Squadron", "No 14 Squadron", 12)',
	},	
	["Reinforce No 15 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/No 15 Squadron", "No 15 Squadron", 12)',
	},
	["Reinforce No 4 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/No 4 Squadron", "No 4 Squadron", 12)',
	},
	["Reinforce No 28 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/No 28 Squadron", "No 28 Squadron", 12)',
	},
	["Reinforce No 30 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/No 30 Squadron", "No 30 Squadron", 12)',
	},
	["Reinforce No 221 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/No 221 Squadron", "No 221 Squadron", 12)',
	},	
	-- ["Reinforce 31.IAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/31.IAP", "31.IAP", 12)',
	-- },
	-- ["Reinforce 28.IAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/28.IAP", "28.IAP", 12)',
	-- },
	-- ["Reinforce 368.ShAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/368.ShAP", "368.ShAP", 16)',
	-- },
	-- ["Reinforce 3.IAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/3.IAP", "3.IAP", 12)',
	-- },
	-- ["Reinforce 559.BAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/559.BAP", "559.BAP", 12)',
	-- },
	-- ["Reinforce 52.TBAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/52.TBAP", "52.TBAP", 16)',
	-- },	
	-- ["Reinforce 959.BAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/959.BAP", "959.BAP", 12)',
	-- },
	-- ["Reinforce 79.TBAP"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/79.TBAP", "79.TBAP", 6)',
	-- },
	-- ["Reinforce 174.IAP-PVO"] = {
		-- active = true,
		-- condition = 'true',
		-- action = 'Action.AirUnitReinforce("R/174.IAP-PVO", "174.IAP-PVO", 6)',
	-- },	

	----- AVIATION UNIT STATUS -----
	["No 30 Squadron Alive 75%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("No 30 Squadron") + Return.AirUnitReady("R/No 30 Squadron") < 10',
		action = 'Action.Text("Aircraft strength of the No 30 Squadron has fallen below 75%.")',
	},
	["No 30 Squadron Alive 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("No 30 Squadron") + Return.AirUnitReady("R/No 30 Squadron") < 7',
		action = 'Action.Text("Aircraft strength of the No 30 Squadron has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
	},
	["No 30 Squadron Alive 25%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("No 30 Squadron") + Return.AirUnitReady("R/No 30 Squadron") < 5',
		action = 'Action.Text("Aircraft strength of the No 30 Squadron has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
	},
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
	
	---- NEWSPAPER ----

	-- ["Newspaper Fulcrum"] = {
		-- active = true,
		-- once = true,
		-- condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		-- action = {
			-- [1] = 'Action.AddImage("Newspaper_Fulcrum.jpg", "blue")',
			-- [2] = 'NoMoreNewspaper = true',
		-- },
	-- },
	-- ["Newspaper Gainful"] = {
		-- active = true,
		-- once = true,
		-- condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		-- action = {
			-- [1] = 'Action.AddImage("Newspaper_Gainful.jpg", "blue")',
			-- [2] = 'NoMoreNewspaper = true',
		-- },
	-- },
	-- ["Newspaper Gecko"] = {
		-- active = true,
		-- once = true,
		-- condition = 'NoMoreNewspaper == nil and Return.Mission() > 1 and math.random(1,10) == 1',
		-- action = {
			-- [1] = 'Action.AddImage("Newspaper_Gecko.jpg", "blue")',
			-- [2] = 'NoMoreNewspaper = true',
		-- },
	-- },
}
